/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.indication.client;

import com.ibm.hsc.indication.client.HSCEvent;
import com.ibm.hsc.indication.client.HSCSubscription;
import com.ibm.hsc.indication.client.HSCSubscriptionMgr;
import java.io.Serializable;

public abstract class HSCCltSubscription
implements Serializable {
    public static final int SUB_SEND_REQUEST = -1;
    public static final int SUB_FAILED = 0;
    public static final int SUB_SUCCESS = 1;
    public static final int RED_HAT_INDICATION_SERVER_PORT = 9198;
    protected int mEvtType;
    protected String mObjType;
    protected int mSubId;
    protected String mUserName;
    protected byte[] mPassword = null;
    protected boolean mSubscription;
    private String mAuthKey = null;

    public HSCCltSubscription(int n, String string, boolean bl, String string2, String string3) {
        this.mEvtType = n;
        this.mObjType = string;
        this.mSubscription = bl;
        this.mUserName = string2;
        if (string3 != null) {
            this.mPassword = this.passEncoding(string3);
        }
        this.mSubId = -1;
    }

    public String getAuthKey() {
        return this.mAuthKey;
    }

    public void setAuthKey(String string) {
        this.mAuthKey = string;
    }

    public abstract HSCCltSubscription copy();

    public abstract void handleEvent(HSCEvent var1, HSCSubscriptionMgr var2);

    public int getEventType() {
        return this.mEvtType;
    }

    public String getObjectType() {
        return this.mObjType;
    }

    public boolean isSubscription() {
        return this.mSubscription;
    }

    public void setSubscription(boolean bl) {
        this.mSubscription = bl;
    }

    public String getUserName() {
        return this.mUserName;
    }

    public String getPassword() {
        if (this.mPassword != null) {
            return this.passDecoding(this.mPassword);
        }
        return null;
    }

    public int getSubId() {
        return this.mSubId;
    }

    public void setSubId(int n) {
        this.mSubId = n;
    }

    private byte[] passEncoding(String string) {
        byte[] byArray = null;
        try {
            byArray = string.getBytes("UTF-8");
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        for (int i = 0; i < byArray.length; ++i) {
            int n = i;
            byArray[n] = (byte)(byArray[n] + i * 2);
        }
        return byArray;
    }

    private String passDecoding(byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length];
        for (int i = 0; i < byArray.length; ++i) {
            byArray2[i] = byArray[i];
            int n = i;
            byArray2[n] = (byte)(byArray2[n] - i * 2);
        }
        String string = null;
        try {
            string = new String(byArray2, "UTF-8");
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return string;
    }

    public String getEventKey() {
        return HSCCltSubscription.getEventKey(this.mEvtType, this.mObjType);
    }

    public static String getEventKey(int n, String string) {
        return string + "-" + n;
    }

    public Object getServerSub(int n) {
        if (n != 9198) {
            HSCSubscription hSCSubscription = new HSCSubscription(this.mEvtType, this.mObjType, this.mSubscription, null, null, null);
            hSCSubscription.setAuthKey(this.mAuthKey);
            return hSCSubscription;
        }
        com.ibm.hsc.cim.provider.rs6k.indication.client.HSCSubscription hSCSubscription = new com.ibm.hsc.cim.provider.rs6k.indication.client.HSCSubscription(this.mEvtType, this.mObjType, this.mSubscription, null, null, null);
        hSCSubscription.setAuthKey(this.mAuthKey);
        return hSCSubscription;
    }
}

